unit Qrssbc;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Quickrep, ssBC;

type
  TQRssBarcode = class(TQRCustomControl)
  private
    FBarcode : TssBarcode;

  protected
    procedure Notification( AComponent: TComponent; Operation: TOperation); override;
    procedure SetBarcode(Value : TssBarcode);
    constructor Create(AOwner : TComponent); override;
  public
    procedure Print(PX,PY : integer); override;
    procedure Paint; override;
  published
    property Barcode : TssBarcode read FBarcode write SetBarcode;
  end;

procedure Register;

implementation

constructor TQrssBarcode.Create(AOwner : TComponent);

begin
  inherited Create(AOwner);
  Width:=200;
  Height:=200;
end;

procedure TQRssBarcode.SetBarcode(Value : TssBarcode);

begin
  FBarcode := Value;
  Invalidate;
end;

procedure TQRssBarcode.Paint;

begin
  if Assigned(FBarcode) then
  begin
    Width := FBarCode.Width;
    Height := FBarcode.Height;
    try
      FBarcode.DataBits := FBarcode.CreateDatabits(Screen.PixelsPerInch);
      FBarcode.AODataBits := FBarcode.CreateAODatabits(Screen.PixelsPerInch);
    finally
      FBarcode.DrawBarcode(Self.Canvas,0,0, Screen.PixelsPerInch);
    end;
  end
  else
  begin
    if (csDesigning in ComponentState) then
    with Canvas do
    begin
      Brush.Color := Self.Color;
      Brush.Style := bsSolid;
      FillRect(ClientRect);
      Pen.Style := psDash;
      Brush.Style := bsClear;
      Rectangle(0, 0, Width, Height);
      Pen.Style := psSolid;
    end;
  end;
end;


procedure TQRssBarcode.Print(PX,PY : integer);

begin
  if Assigned(FBarcode) then
  begin
    try
      FBarcode.DataBits := FBarcode.CreateDatabits(qrOrgRes);
      FBarcode.AODataBits := FBarcode.CreateAODatabits(qrOrgRes);

    finally
      FBarcode.DrawBarcode(QRPrinter.Canvas,PX+Left,PY+Top, qrOrgRes);
    end;
  end;
end;

procedure TQrssBarcode.Notification( AComponent: TComponent; Operation: TOperation);

begin
  inherited Notification(AComponent, Operation);
  if (Operation=opRemove) and (AComponent=FBarcode) then
    SetBarcode(nil);
end;

procedure Register;
begin
  RegisterComponents('Soft Sector', [TQRssBarcode]);
end;

end.
